#ifndef _CAMERA_H_
#define _CAMERA_H_

#include "ifile.h"

typedef struct {

  char name[32];

  VECTOR *location;
  VECTOR *look_at;
  VECTOR up;

  MATRIX world_transform;
  VECTOR world_translate;
  MATRIX world_transform_inverted;

  float distance;
  float perspective;

  int numframes;
  int numtargetframes;
  VECTOR *frame_location;
  VECTOR *frame_look_at;

  float xaspect, yaspect;
  float xcenter, ycenter;

} CAMERA;

extern void camera_create( CAMERA *c, char *name );
extern void camera_destroy( CAMERA *c );
extern void camera_calcframe( CAMERA *c, long frame );
extern void camera_set( CAMERA *c, VECTOR *v1, VECTOR *v2 );
extern void camera_roll( CAMERA *c, ROT angle );
extern int camera_projectpoint( CAMERA *c, VECTOR *dest, VECTOR *source );
extern void camera_render( CAMERA *c, RENDER *r );
extern void camera_load_fp( CAMERA *c, IFILE *fp );
extern void camera_load( CAMERA *c, char *filename );
extern void camera_set( CAMERA *c, VECTOR *v1, VECTOR *v2 );

#endif
